IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Manage_Deleted_Movements]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Manage_Deleted_Movements]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author		:	PII
-- Created date	:	12/18/2012
-- Description	:	Delete movements.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Manage_Deleted_Movements] 
	@IEN NVARCHAR(MAX),
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@VISTA_SITE_CODE NVARCHAR(20)
AS
BEGIN
	SET NOCOUNT ON;

	CREATE TABLE #temp (NR INT, IEN NVARCHAR(20))
	
	INSERT INTO #temp (NR, IEN)
	SELECT ID, VALUE
		FROM dbo.fn_Split_String(@IEN, ',')
		
	DECLARE @I INT, @MAX INT, @tmpIEN NVARCHAR(20), @ID INT, @ADM_ID INT,
			@ID2 INT, @BED UNIQUEIDENTIFIER, @WARD UNIQUEIDENTIFIER, @DIS_ID INT, @MOVEMENT_DATE DATETIME
	SELECT @MAX = COUNT(NR) FROM #temp
	SET @I = 1
	WHILE (@I <= @MAX) 
		BEGIN
			SELECT @tmpIEN = IEN FROM #temp WHERE NR = @I
			SELECT @ID = ID FROM SPECIALTY_TRANSFER WHERE IEN = @tmpIEN AND VISTA_SITE_UID = @VISTA_SITE_UID
			IF (@ID IS NOT NULL)
				DELETE FROM SPECIALTY_TRANSFER WHERE ID = @ID
			ELSE
				BEGIN
					SELECT @ID = ID, @ADM_ID = ADMISSION_ID FROM DISCHARGE_EVN WHERE IEN = @tmpIEN AND VISTA_SITE_UID = @VISTA_SITE_UID
					IF (@ID IS NOT NULL)
						BEGIN
							IF NOT EXISTS (SELECT ID FROM DISCHARGE_EVN WHERE CAST(IEN AS BIGINT) > CAST(@tmpIEN AS BIGINT) AND ADMISSION_ID = @ADM_ID)
								UPDATE ADMISSION_EVN 
									SET HAS_DISCHARGE = 0 WHERE ID = @ADM_ID
							DELETE FROM DISCHARGE_EVN WHERE ID = @ID
						END
					ELSE
						BEGIN
							SELECT @ID = ID, @ADM_ID = ADMISSION_ID, @BED = OLD_BED_UID, @WARD = OLD_WARD_UID, @MOVEMENT_DATE = MOVEMENT_DATE 
								FROM MOVEMENT_EVN WHERE IEN = @tmpIEN AND VISTA_SITE_UID = @VISTA_SITE_UID
							IF (@ID IS NOT NULL)
								BEGIN																		
									SELECT TOP 1 @ID2 = ID FROM MOVEMENT_EVN WHERE ADMISSION_ID = @ADM_ID AND MOVEMENT_DATE > @MOVEMENT_DATE ORDER BY MOVEMENT_DATE
									IF (@ID2 IS NOT NULL)
										UPDATE MOVEMENT_EVN 
											SET OLD_WARD_UID = @WARD, OLD_BED_UID = @BED 
											WHERE ID = @ID2
									ELSE
										BEGIN
											UPDATE ADMISSION_EVN 
												SET WARD_UID = @WARD, BED_UID = @BED 
												WHERE ID = @ADM_ID
											SELECT @DIS_ID = ID FROM DISCHARGE_EVN WHERE ADMISSION_ID = @ADM_ID
											IF (@DIS_ID IS NOT NULL)
												UPDATE DISCHARGE_EVN
													SET WARD_UID = @WARD, BED_UID = @BED
													WHERE ID = @DIS_ID
										END
									DELETE FROM BED_SWITCH WHERE IEN = @tmpIEN AND VISTA_SITE_UID = @VISTA_SITE_UID
									DELETE FROM MOVEMENT_EVN WHERE ID = @ID
								END
							ELSE
								BEGIN
									SELECT @ID = ID FROM ADMISSION_EVN WHERE IEN = @tmpIEN AND VISTA_SITE_UID = @VISTA_SITE_UID
									IF (@ID IS NOT NULL)
										BEGIN
											DELETE FROM VISTA_INTEGRATION_LOG WHERE VISTA = @VISTA_SITE_CODE AND VISTA_FILE = 'PM' 
												AND IEN IN (SELECT IEN FROM SPECIALTY_TRANSFER WHERE ADMISSION_ID = @ID)
											DELETE FROM SPECIALTY_TRANSFER WHERE ADMISSION_ID = @ID
											DELETE FROM VISTA_INTEGRATION_LOG WHERE VISTA = @VISTA_SITE_CODE AND VISTA_FILE = 'PM' 
												AND IEN IN (SELECT IEN FROM MOVEMENT_EVN WHERE ADMISSION_ID = @ID)
											DELETE FROM MOVEMENT_EVN WHERE ADMISSION_ID = @ID
											DELETE FROM VISTA_INTEGRATION_LOG WHERE VISTA = @VISTA_SITE_CODE AND VISTA_FILE = 'PM' 
												AND IEN IN (SELECT IEN FROM DISCHARGE_EVN WHERE ADMISSION_ID = @ID)
											DELETE FROM DISCHARGE_EVN WHERE ADMISSION_ID = @ID
											DELETE FROM BED_SWITCH WHERE ADMISSION_ID = @ID
											DELETE FROM ADMISSION_LEVEL_OF_CARE WHERE ADMISSION_ID = @ID
											DELETE FROM ADMISSION_EVN WHERE ID = @ID
										END
								END
							SET @ID2 = NULL 
							SET @BED = NULL 
							SET @WARD = NULL 
							SET @DIS_ID = NULL 
							SET @MOVEMENT_DATE = NULL
						END
				END
			DELETE FROM VISTA_INTEGRATION_LOG WHERE VISTA = @VISTA_SITE_CODE AND VISTA_FILE = 'PM' AND IEN = @tmpIEN
			SET @I = @I + 1
			SET @ID = NULL
			SET @ADM_ID = NULL
		END
	
	DROP TABLE #temp
END
GO